package multisab.processing.machineLearning.normalization;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Davor on 10.10.2016..
 */
public class OneOfNStringCoder extends Coder {

    Map<Integer, String> mapClasses = new HashMap<Integer, String>();
    Map<String, Integer> inverseMapClasses = new HashMap<String, Integer>();

    public OneOfNStringCoder(double outputNormalizationMin, double outputNormalizationMax, int numberOfClasses) {
        super(outputNormalizationMin, outputNormalizationMax, numberOfClasses);
    }

    @Override
    public double[][] encode(String[] classes){

        int numberOfSamples = classes.length;

        numberOfClasses = 0;
        mapClasses.put(numberOfClasses, classes[0]);
        inverseMapClasses.put(classes[0], numberOfClasses);
        numberOfClasses++;

        for(int j = 1; j < numberOfSamples; j++) {
            if (!mapClasses.containsValue(classes[j])) {
                mapClasses.put(numberOfClasses, classes[j]);
                inverseMapClasses.put(classes[j], numberOfClasses);
                numberOfClasses++;
            }
        }

        double[][] ideal = new double[numberOfSamples][numberOfClasses];

        for(int j = 0; j < numberOfSamples; j++)  {
            int intClass = inverseMapClasses.get(classes[j]);
            for(int i = 0; i < (numberOfClasses); i++) {
                ideal[j][i] = outputNormalizationMin;
            }
            ideal[j][intClass] = outputNormalizationMax;
        }

        return ideal;
    }

    @Override
    public String decodeToString(double[] clasifierOutput) {

        int numberOfClasses = clasifierOutput.length;

        int index = 0;
        double max = clasifierOutput[0];

        for(int i = 1; i < numberOfClasses; i++) {
            if(clasifierOutput[i] > max) {
                index = i;
                max = clasifierOutput[i];
            }
        }

        return mapClasses.get(index);
    }
}
