package multisab.processing.preprocessing.qrsDetection;

import multisab.processing.machineLearning.normalization.Normalization;
import multisab.processing.preprocessing.filtering.Filter;
import multisab.processing.preprocessing.filtering.FilterTransferFunction;
import multisab.processing.preprocessing.morphologicalOperations.MMOperators;
import multisab.processing.preprocessing.otherFunctions.ArrayFunctions;
import multisab.processing.preprocessing.otherFunctions.FindLocalExtremes;



import java.util.ArrayList;
import java.util.*;


/**
 * Created by Krešimir on 4.1.2017..
 */
public class Elgendi {


    public static List<Double> QRSindex = new ArrayList<Double>();

    public static List<Double> DetectRSpike(double[] ecg, double fs){

        /***Parameter initialization****/
        int W1 = (int)(0.097*fs);
        int W2 = (int)(0.611*fs);
        double beta = 0.08;


        //Filter signal
        double [] Filtered = ElgendiFilterECG(ecg, fs, 20, 8);

        //Squaring signal
        double [] SqFiltered = ArrayFunctions.Squaring(Filtered,0,Filtered.length);

        //Moving Averages
        double [] MAqrs = MovingAverage(SqFiltered,W1);
        double [] MAbeat = MovingAverage(SqFiltered,W2);

        //Offset
        double z = ArrayFunctions.Mean(SqFiltered,1,SqFiltered.length);
        double alpha = beta*z;

        //BlocksOfInterest
        double [] BlocksOfInterest = new double[MAqrs.length];
        int numberOfBlocks = 0;
        double THR1 = 0;
        for (int n = 1; n < MAqrs.length; n++) {
            THR1 = MAbeat[n] + alpha;
            if (MAqrs[n] >= THR1) {
                BlocksOfInterest[n] = 0.1;
                numberOfBlocks ++;
            } else {
                BlocksOfInterest[n] = 0;
            }
        }
        BlocksOfInterest[BlocksOfInterest.length - 1] = 0;

        //Find lengths of Blocks
        int k = 0;
        double [] Blocks = new double[(int)(numberOfBlocks/2)+1];
        for (int b = 1; b < BlocksOfInterest.length; b++) {
            if (BlocksOfInterest[b] - BlocksOfInterest[b - 1] != 0) {
                Blocks[k] = b;
                k = k + 1;
            }
        }

        //Test length of Blocks
        double THR2 = W1;
        double [] RPeak;
        for (int j = 1;j < Blocks.length; j = j + 2) {
            if (Blocks[j] - Blocks[j - 1] >= THR2) {
                RPeak = FindLocalExtremes.findMaximum(SqFiltered, (int)Blocks[j - 1], (int)Blocks[j]);
                QRSindex.add(RPeak[1] + 1);

            }
        }

        return QRSindex;
    }
    public static List<Double> DetectPTWaves(double[] ecg, double fs, double[] QRS, String PT){

        double[] x = ElgendiFilterECG(ecg,fs,10,0.5);

        //Removing R spikes
        int n = x.length;
        for (double i = 0; i < n; i++){

            if (contains(QRS,i)){
                if (i < fs*0.083){
                    for (int j = 0; j < i+Math.round(0.166*fs); j++){
                        x[j] = 0;
                    }
                }
                else if (i > n - Math.round(0.166*fs)){
                    for (int j = (int)(i - Math.round(0.083*fs)); j < n; j++){
                        x[j] = 0;
                    }
                }

                else {
                    for (int j = (int)(i - Math.round(0.083*fs)); j < i + Math.round(0.166*fs); j++){
                        x[j] = 0;
                    }
                }
            }
        }


        //Moving Averages
        int W1 = (int)(0.055*fs);
        int W2 = (int)(0.110*fs);

        double [] MAPeak = MovingAverage(x,W1);
        double [] MAPwave = MovingAverage(x,W2);

        //Blocks of interest
        double [] BlocksOfInterest = new double[n];
        int numberOfBlocks = 0;

        for (int k = 0; k < MAPwave.length; k++){
            if (MAPeak[k] > MAPwave[k]){
                BlocksOfInterest[k] = 1;
                numberOfBlocks ++;
            }
            else BlocksOfInterest[k] = 0;
        }

        //Get blocks indexes
        BlocksOfInterest[BlocksOfInterest.length - 1] = 0;
        BlocksOfInterest[0] = 0;

        int k = 0;
        double [] Blocks = new double[(int)(numberOfBlocks/2)+1];
        for (int b = 1; b < BlocksOfInterest.length; b++) {
            if (BlocksOfInterest[b] - BlocksOfInterest[b - 1] != 0) {
                Blocks[k] = b;
                k = k + 1;
            }
        }

        //Reject noisy blocks
        List<Double> BlocksNoNoisy = new ArrayList<Double>();
        List<Double> BlocksMax = new ArrayList<Double>();
        double [] temp;
        for (int j = 1;j < Blocks.length; j = j + 2) {
            if (Blocks[j] - Blocks[j - 1] < W1*0.5) {
                for (double i = Blocks[j - 1]; i < Blocks[j]; i++) {
                    BlocksOfInterest[(int) i] = 0;
                }
            }
            else {
                BlocksNoNoisy.add(Blocks[j-1]);
                BlocksNoNoisy.add(Blocks[j]);

                temp = FindLocalExtremes.findMaximum(x,(int)Blocks[j-1],(int)Blocks[j]);
                BlocksMax.add(temp[1]);
            }
        }


        //Search for P waves
        List<Double> Pwaves = new ArrayList<Double>();
        double Pmin = Math.round(0.055*fs);
        double Pmax = Math.round(0.470*fs);

        List<Double> Twaves = new ArrayList<Double>();

        double [] QRS2 = QRS;

        for (int r = 0; r < QRS2.length - 1; r++){
            double R1 = QRS2[r];
            double R2 = QRS[r+1];


            double Tmin = Math.round((R2-R1)/fs*0.110*fs);
            double Tmax = Math.round((R2-R1)/fs*0.583*fs);

            List<Double> tempBlocks = new ArrayList<Double>();
            List<Double> RRPwaves = new ArrayList<Double>();
            List<Double> RRTwaves = new ArrayList<Double>();

            for (int b = 0; b < BlocksMax.size(); b++){
                if ((BlocksMax.get(b) < R2) && (BlocksMax.get(b) > R1)){
                    tempBlocks.add(BlocksMax.get(b));
                }
            }

            if (tempBlocks.size() > 1){
                for (int t = 0; t < tempBlocks.size(); t++){
                    if (tempBlocks.get(t) > (Tmin + R1) && tempBlocks.get(t) < (Tmax + R1)){
                        RRTwaves.add(tempBlocks.get(t));
                    }

                    if (tempBlocks.get(t) < (R2 - Pmin) && tempBlocks.get(t) > (R2 -  Pmax)){
                        RRPwaves.add(tempBlocks.get(t));
                    }
                }
                double tempP = -Double.MAX_VALUE;
                double tempPI = 0;
                for (double p: RRPwaves){
                    if (x[(int)p] > tempP ) {
                        tempP = x[(int) p];
                        tempPI = p;
                    }
                }
                Pwaves.add(tempPI);

                double tempT = -Double.MAX_VALUE;
                double tempTI = 0;
                for (double t: RRTwaves){
                    if (x[(int)t] > tempT ) {
                        tempT = x[(int) t];
                        tempTI = t;
                    }
                }
                Twaves.add(tempTI);


            }



        }
        if (PT.equals("T")) return Twaves;
        else return Pwaves;
    }
    public static double [] ElgendiFilterECG (double [] x, double fs, double f1, double f2) {

        //Lowpass filtering - cutoff freq. about 11 Hz
        FilterTransferFunction lowpass = new FilterTransferFunction(f1, fs, "lowBiquad");

        double [] lowPassA = lowpass.getA();
        double [] lowPassB = lowpass.getB();

        double[] lowPassSignal = Filter.filterSignal(x,lowPassB, lowPassA);
        lowPassSignal = ArrayFunctions.Normalization(lowPassSignal);
        //Highpass filtering - cutoff freq. about 5 Hz
        FilterTransferFunction highpass = new FilterTransferFunction(f2, fs, "highBiquad");
        double [] highPassA = lowpass.getA();
        double [] highPassB = lowpass.getB();

        double [] y = Filter.filterSignal(lowPassSignal, highPassB, highPassA);
        y = ArrayFunctions.Normalization(y);
        return y;
    }
    public static double [] MovingAverage (double[] x, int N) {
        int n = x.length;
        double[] MA = new double[n];
        double sum = 0;
        int i;

        for (i = (int) ((N - 1) / 2); i < n - (int) ((N - 1) / 2); i++) {
            sum = 0;
            for (int j = i - (int) ((N - 1) / 2); j < i + (int) ((N - 1) / 2); j++) {
                sum += x[j];
            }
            MA[i] = sum / N;
        }

        for (i = 0; i < (int) (N - 1) / 2; i++) {
            sum = 0;
            for (int j = i; j < i + N; j++) {
                sum += x[j];
            }
            MA[i] = sum / N;
        }

        for (i = n - (int) ((N - 1) / 2); i < n; i++) {
            sum = 0;
            for (int j = i - N; j < i; j++) {
                sum += x[j];
            }
            MA[i] = sum / N;
        }


        return MA;
    }
    public static boolean contains(double[] arr, double item) {
        for (double n : arr) {
            if (item == n) {
                return true;
            }
        }
        return false;
    }

}
