#ifndef CENTRALFORCEOPTIMIZATION_H_
#define CENTRALFORCEOPTIMIZATION_H_

#include <ecf/ECF.h>
#include <vector>


class CentralForceOptimization : public Algorithm
{
protected:
	double global_best;
	vector<double> global_best_pos;
	
	// broj dimenzija funkcije
	uint dimensions;

	// pocetne granice prostora
	double xmin_init;
	double xmax_init;

	// parametri faktora vracanja
	double Finit;
	double Fdelta;
	double Fmin;

	// parametri iteracije
	uint max_pop_per_dimension;
	uint pop_per_dimension;
	uint gamma;

	// pomocna klasa
	class Probe;


	void spawnProbes(DemeP deme, std::vector<Probe> &probes, std::vector<double> &xmin, std::vector<double> &xmax);

	void moveProbes(std::vector<Probe> &probes);
	void retrieveProbes(std::vector<Probe> &probes, std::vector<double> &xmin, std::vector<double> &xmax, const double Frep);
	void calcProbeMasses(DemeP deme, std::vector<Probe> &probes);
	void calcAccelerations(DemeP deme, std::vector<Probe> &probes);

	void findBestFitness(DemeP deme, std::vector<Probe> &probes, double &best_fitness, std::vector<double> &pos_of_best);
	bool checkTerminationCondition(const double best_fitness, double *fmax_history);
	void shrinkSearchSpace(std::vector<double> &xmin, std::vector<double> &xmax, std::vector<double> &pos_of_max);

	void iterateParameters();

public:
	CentralForceOptimization();
	bool initialize(StateP state);
	bool advanceGeneration(StateP state, DemeP deme);
};
typedef boost::shared_ptr<CentralForceOptimization> CentralForceOptimizationP;


#endif